import os
from omegaconf import OmegaConf

def get_config(path_to_conf_file, num_checkpoint=105):
    model_checkpoint = 'model-{}.th'.format(num_checkpoint)
    model_path = os.path.join(os.path.split(path_to_conf_file)[0], model_checkpoint)
    config = OmegaConf.load(path_to_conf_file)
    config.num_hidden = config.num_hidden.value
    config.num_commands = config.num_commands.value
    config.npoints = config.npoints.value
    config.nblocks = config.nblocks.value
    config.nneighbor = config.nneighbor.value
    config.num_output = config.num_output.value
    config.input_dim = config.input_dim.value
    config.transformer_dim = config.transformer_dim.value
    config.max_num_neighbors = config.max_num_neighbors.value
    return config, model_path
